/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 **************************************************************************//*!
 *
 * @file phd_device_spec.c
 *
 * @author
 *
 * @version
 *
 * @date June-16-2009

 * @brief This file contains all the data and functions of the various device
 *        specializations supported
 *****************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/
#include <string.h>				
#include "derivative.h"             /* include peripheral declarations */
#include "types.h"                  /* User Defined Data Types */
#if(defined LITTLE_ENDIAN)
#include "ieee11073_phd_types_kinetis.h"    /* IEEE11073 Data Structures */
#else
#include "ieee11073_phd_types.h"    /* IEEE11073 Data Structures */
#endif
#include "ieee11073_nom_codes.h"    /* IEEE11073 Nomenclature Codes */
#include "phd_com_model.h"
#include "phd_device_spec.h"
#include "user_config.h"

#include "PulseOximeter.h"

/*****************************************************************************
 * Global Functions Prototypes
 *****************************************************************************/

/****************************************************************************
 * Global Variables
 ****************************************************************************/
/*****************************************************************************
 * Local Types 
 *****************************************************************************/

#define OXI_FIXEDREPORT_SCANREPORT_NO_POSITION        24 //Scan Report No. position on fixed report array
#define OXI_FIXEDREPORT_SPO2_MEAS_POSITION            35 //SpO2 Measurement position on fixed report array
#define OXI_FIXEDREPORT_PRV_MEAS_POSITION             49 //Pulse Rate Value position on fixed report array
#define OXI_FIXEDREPORT_SPO2_MIN_POSITION             41 //Timestamp Minutes value position
#define OXI_FIXEDREPORT_PRV_MIN_POSITION              55 //Timestamp Minutes value position

/*****************************************************************************
 * Local Functions Prototypes
 *****************************************************************************/
/* Update Pulse Oximeter measurements */
static void PHD_Send_OXI_Measurements_to_Manager (
    uint_8 controller_ID,
    void* buffer_ptr,
    void* size
);


#if (defined __MCF52xxx_H__)||(defined LITTLE_ENDIAN)
/* Put CFV2 hardcoded messages in RAM */
#define USB_CONST
#else
/* Const placement */
#define USB_CONST		const
#endif

/*****************************************************************************
 * Constant and Macro's
 *****************************************************************************/ 
/* abort apdu */
uint_8 USB_CONST PHD_ABRT[ABRT_SIZE] = {
0xE6, 0x00,                           /* APDU CHOICE Type (RlrsApdu) */
0x00, 0x02,                           /* CHOICE.length = 2 */
0x00, 0x02                            /* reason = normal */
};

/* Pulse Oximeter*/

/* association request to send */ 
uint_8 USB_CONST PHD_OXI_ASSOC_REQ[ASSOC_REQ_SIZE] = {   
0xE2, 0x00,                         /* APDU CHOICE Type (AarqApdu) */
0x00, 0x32,                         /* CHOICE.length = 50 */
0x80, 0x00, 0x00, 0x00,             /* assoc-version */
0x00, 0x01, 0x00, 0x2A,             /* data-proto-list.count=1 | length=42*/
0x50, 0x79,                         /* data-proto-id = 20601 */
0x00, 0x26,                         /* data-proto-info length = 38 */
0x80, 0x00, 0x00, 0x00,             /* protocolVersion */
0x80, 0x00,                         /* encoding rules = MDER or PER */ 
0x80, 0x00, 0x00, 0x00,             /* nomenclatureVersion */
0x00, 0x00, 0x00, 0x00,             /* functionalUnits | 
                                      no test association capabilities */
0x00, 0x80, 0x00, 0x00,             /* systemType = sys-type-agent */
0x00, 0x08,                         /* system-id length = 8 and value 
    ,                                 (manufacturer- and device- specific) */
0x4C, 0x4E, 0x49, 0x41, 0x47, 0x45, 0x4E, 0x54,
0x40, 0x00,                         /* dev-config-id | extended configuration*/ 
0x00, 0x01,                         /* data-req-mode-flags 0x00, 0x01*/
0x01, 0x00,                         /* data-req-init-agent-count, 
                                      data-req-init-manager-count */
0x00, 0x00, 0x00, 0x00              /* Atribute list */
};

/* configuration event report */ 
uint_8 USB_CONST PHD_OXI_CNFG_EVT_RPT[PHD_OXI_CNFG_EVT_RPT_SIZE] = {   
0xE7, 0x00,                           /* APDU CHOICE Type (PrstApdu) */
0x00, 0x70,                           /* CHOICE.length = 112 */
0x00, 0x6E,                           /* OCTET STRING.length = 110 */
0x00, 0x02,                           /* invoke-id (differentiates this from other outstanding messages) */
0x01, 0x01,                           /* CHOICE(Remote Operation Invoke | Confirmed Event Report) */
0x00, 0x68,                           /* CHOICE.length = 104 */
0x00, 0x00,                           /* obj-handle = 0 (MDS object) */
0xFF, 0xFF, 0xFF, 0xFF,               /* event-time = 0xFFFFFFFF */
0x0D, 0x1C,                           /* event-type = MDC_NOTI_CONFIG */
0x00, 0x5E,                           /* event-info.length = 94 (start of ConfigReport) */
0x40, 0x00,                           /* config-report-id */
0x00, 0x02,                           /* config-obj-list.count = 2 Measurement objects will be announced */
0x00, 0x58,                           /* config-obj-list.length = 88 */
0x00, 0x06,                           /* obj-class = MDC_MOC_VMO_METRIC_NU */
0x00, 0x01,                           /* obj-handle = 1 (.. 1st Measurement is SpO2) */
0x00, 0x04,                           /* attributes.count = 4 */
0x00, 0x24,                           /* attributes.length = 36 */
0x09, 0x2F,                           /* attribute-id = MDC_ATTR_ID_TYPE */
0x00, 0x04,                           /* attribute-value.length = 4 */
0x00, 0x02, 0x4B, 0xB8,               /* MDC_PART_SCADA | MDC_PULS_OXIM_SAT_O2 */
0x0A, 0x46,                           /* attribute-id = MDC_ATTR_METRIC_SPEC_SMALL */
0x00, 0x02,                           /* attribute-value.length = 2 */
0x40, 0xC0,                           /* avail-stored-data, acc-manager-init, acc-agent-init, measured */
0x09, 0x96,                           /* attribute-id = MDC_ATTR_UNIT_CODE */
0x00, 0x02,                           /* attribute-value.length = 2 */
0x02, 0x20,                           /* MDC_DIM_PERCENT */
0x0A, 0x55,                           /* attribute-id = MDC_ATTR_ATTRIBUTE_VAL_MAP */
0x00, 0x0C,                           /* attribute-value.length = 12 */
0x00, 0x02,                           /* AttrValMap.count = 2 */
0x00, 0x08,                           /* AttrValMap.length = 8*/
0x0A, 0x4C, 0x00, 0x02,               /* MDC_ATTR_NU_VAL_OBS_BASIC | value length = 2 */
0x09, 0x90, 0x00, 0x08,               /* MDC_ATTR_TIME_STAMP_ABS | value length = 8 */
0x00, 0x06,                           /* obj-class = MDC_MOC_VMO_METRIC_NU */
0x00, 0x02,                           /* obj-handle = 2 (..2nd Measurement is pulse rate) */
0x00, 0x04,                           /* attributes.count = 4 */
0x00, 0x24,                           /* attributes.length = 36 */
0x09, 0x2F,                           /* attribute-id = MDC_ATTR_ID_TYPE */
0x00, 0x04,                           /* attribute-value.length = 4 */
0x00, 0x02, 0x48, 0x1A,               /* MDC_PART_SCADA | MDC_PULS_OXIM_PULS_RATE */
0x0A, 0x46,                           /* attribute-id = MDC_ATTR_METRIC_SPEC_SMALL */
0x00, 0x02,                           /* attribute-value.length = 2 */
0x40, 0xC0,                           /* avail-stored-data, acc-manager-init, acc-agent-init, measured */
0x09, 0x96,                           /* attribute-id = MDC_ATTR_UNIT_CODE */
0x00, 0x02,                           /* attribute-value.length = 2 */
0x0A, 0xA0,                           /* MDC_DIM_BEAT_PER_MIN */
0x0A, 0x55,                           /* attribute-id = MDC_ATTR_ATTRIBUTE_VAL_MAP */
0x00, 0x0C,                           /* attribute-value.length = 12 */
0x00, 0x02,                           /* AttrValMap.count = 2 */
0x00, 0x08,                           /* AttrValMap.length = 8 */
0x0A, 0x4C, 0x00, 0x02,               /* MDC_ATTR_NU_VAL_OBS_BASIC, 2 */
0x09, 0x90, 0x00, 0x08                /* MDC_ATTR_TIME_STAMP_ABS, 8 */
};       

/* release request to send */
uint_8 USB_CONST PHD_OXI_REL_REQ[REL_REQ_SIZE] = {   
0xE4, 0x00,                           /* APDU CHOICE Type (RlrqApdu) */
0x00, 0x02,                           /* CHOICE.length = 2 */
0x00, 0x00                            /* reason = normal */
};

/* release response to the host */
uint_8 USB_CONST PHD_OXI_REL_RES[REL_RES_SIZE] = {   
0xE5, 0x00,                           /* APDU CHOICE Type (RlrsApdu) */
0x00, 0x02,                           /* CHOICE.length = 2 */
0x00, 0x00                            /* reason = normal */
};

/* response to get attributes command */
uint_8 USB_CONST PHD_OXI_DIM_GET_RSP[PHD_OXI_DIM_GET_RSP_SIZE] = {   
0xE7, 0x00,                      /* APDU CHOICE Type (PrstApdu) */
0x00, 0x6F,                      /* CHOICE.length = 111 */
0x00, 0x6D,                      /* OCTET STRING.length = 109 */
0x00, 0x02,                      /* invoke-id =0x0002 (mirrored from request)*/
0x02, 0x03,                      /* CHOICE (Remote Operation Response | Get)*/
0x00, 0x67,                      /* CHOICE.length = 103                     */
0x00, 0x00,                      /* handle = 0 (MDS object)                */
0x00, 0x06,                      /* attribute-list.count = 6               */
0x00, 0x61,                      /* attribute-list.length = 97              */
0x0A, 0x5A,                      /* attribute id=MDC_ATTR_SYS_TYPE_SPEC_LIST */         
0x00, 0x08,                      /* attribute-value.length = 8              */
0x00, 0x01,                      /* TypeVerList count = 1                   */
0x00, 0x04,                      /* TypeVerList length = 4                  */
0x10, 0x04,                      /* type = MDC_DEV_SPEC_PROFILE_PULS_OXIM */
0x00, 0x01,                      /* version=ver 1 of the specialization  */
0x09, 0x28,                      /* attribute-id = MDC_ATTR_ID_MODEL    */
0x00, 0x1B,                      /* attribute-value.length = 27        */
0x00, 0x0A, 0x46, 0x72,          /* string length = 10 | TheCompany  */
0x65, 0x65, 0x73, 0x63,                                                     
0x61, 0x6C, 0x65, 0x20,
0x00, 0x0D, 'M', 'E',          /* string length = 13 | MED-SPO2 PHDC    */
'D', '-', 'S', 'P',
'O', '2', ' ', 'P',
'H', 'D', 'C',
0x09, 0x84,                      /* attribute-id = MDC_ATTR_SYS_ID        */
0x00, 0x0A,                      /* attribute-value.length = 10            */
0x00, 0x08, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 
                                 /* octet string length = 8 | EUI-64  */
0x0a, 0x44,                      /* attribute-id = MDC_ATTR_DEV_CONFIG_ID   */
0x00, 0x02,                      /* attribute-value.length = 2             */
0x40, 0x04,                      /* dev-config-id = 16384 
                                    (extended-config-start)*/
0x09, 0x2D,                      /* attribute-id = MDC_ATTR_ID_PROD_SPECN */
0x00, 0x12,                      /* attribute-value.length = 18           */
0x00, 0x01,                      /* ProductionSpec.count = 1              */
0x00, 0x0E,                      /* ProductionSpec.length = 14             */
0x00, 0x01,                      /* ProdSpecEntry.spec-type=1(serial-number)*/
0x00, 0x00,                      /* ProdSpecEntry.component-id = 0     */
0x00, 0x08, 0x44, 0x45,          /* string length = 8 | 
                                    prodSpecEntry.prod-spec = DE124567 */
0x31, 0x32, 0x34, 0x35,
0x36, 0x37,                                                            
0x09, 0x87,                      /* attribute-id =MDC_ATTR_TIME_ABS */
0x00, 0x08,                      /* attribute-value.length = 8  */
0x20, 0x09, 0x06, 0x12,          /* Absolute-Time-Stamp=2009-06-12T12:05:0000*/
0x12, 0x05, 0x00, 0x00                                                               
};  

/* measurements to send */
uint_8  USB_CONST PHD_OXI_DIM_DATA_TX[PHD_OXI_DIM_DATA_TX_SIZE] = {   
0xE7, 0x00, /*APDU CHOICE Type (PrstApdu)*/
0x00, 0x36, /*CHOICE.length = 54*/
0x00, 0x34, /*OCTET STRING.length = 52*/
0x12, 0x36, /*invoke-id = 0x1236*/
0x01, 0x01, /*CHOICE(Remote Operation Invoke | Confirmed Event Report)*/
0x00, 0x2E, /*CHOICE.length = 46*/
0x00, 0x00, /*obj-handle = 0 (MDS object)*/
0x00, 0x00, 0x00, 0x00, /*event-time = 0*/
0x0D, 0x1D, /*event-type = MDC_NOTI_SCAN_REPORT_FIXED*/
0x00, 0x24, /*event-info.length = 36*/
0xF0, 0x00, /*ScanReportInfoFixed.data-req-id = 0xF000*/
0x00, 0x00, /*ScanReportInfoFixed.scan-report-no = 0*/
0x00, 0x02, /*ScanReportInfoFixed.obs-scan-fixed.count = 2*/
0x00, 0x1C, /*ScanReportInfoFixed.obs-scan-fixed.length = 28*/
0x00, 0x01, /*ScanReportInfoFixed.obs-scan-fixed.value[0].obj-handle = 1*/
0x00, 0x0A, /*ScanReportInfoFixed.obs-scan-fixed.value[0]. obs-val-data.length 
              = 10*/
0x00, 0x61, /*Simple-Nu-Observed-Value = 97% SpO2*/
0x20, 0x0B, 0x09, 0x23, /*Absolute-Time-Stamp = 2011-09-23T10:05:0000*/
0x0A, 0x05, 0x00, 0x00,
0x00, 0x02, /* ScanReportInfoFixed.obs-scan-fixed.value[1].obj-handle = 2*/
0x00, 0x0A, /* ScanReportInfoFixed.obs-scan-fixed.value[1]. obs-val-data.length
               = 10*/
0x00, 0x4E, /* Simple-Nu-Observed-Value = 78 BPM*/
0x20, 0x0B, 0x09, 0x23, /*Absolute-Time-Stamp = 2011-09-23T10:05:0000*/
0x0A, 0x05, 0x00, 0x00
};

PHD_CNF_PARAM const g_phd_cnf_param[MAX_DEV_SPEC_SUPPORTED] = 
{
	{
		(uint_8_ptr)PHD_OXI_ASSOC_REQ,
		(uint_8_ptr)PHD_OXI_CNFG_EVT_RPT,
		PHD_OXI_CNFG_EVT_RPT_SIZE,
		(uint_8_ptr)PHD_OXI_REL_REQ,
		(uint_8_ptr)PHD_OXI_REL_RES,
		(uint_8_ptr)PHD_OXI_DIM_GET_RSP,
		PHD_OXI_DIM_GET_RSP_SIZE,
		0x4000,
		PHD_Send_OXI_Measurements_to_Manager,
	},
	
};

#ifdef _MC9S08JS16_H
#pragma DATA_SEG DEFAULT
#endif
PHD_MEASUREMENT msr;                           

uint_16 scanReportNo;

/******************************************************************************
 *
 *    @name        PHD_Send_OXI_Measurements_to_Manager
 *
 *    @brief       This function is called by the com model when the device 
 *                 specialization selected is Pulse Oximeter
 *
 *    @param       controller_ID : Controller ID
 *    @param       buffer_ptr    : Measurement buffer
 *    @param       size          : Buffer size
 * 
 *    @return      None
 *
 *****************************************************************************
 * This function when called updates the weigh scale measurements 
 *****************************************************************************/
static void PHD_Send_OXI_Measurements_to_Manager (
    uint_8 controller_ID,       /* [IN] Controller ID */    
    void* buffer_ptr,           /* [IN] Measurement buffer */
    void* size                  /* [IN] Buffer size */
)
{
  static uint_8 au8TimestampArray[2] = {10,5}; //Timestamp array positioned to 10:05am
	uint_8 i=0;
	uint_8_ptr send_buff = (uint_8_ptr)buffer_ptr;

  DATA_apdu *dataApdu = (DATA_apdu *)&(((PRST_apdu *)&((APDU *)send_buff)->u.prst)->value[0]);
  ScanReportInfoFixed *scan_rep = (ScanReportInfoFixed *)&(dataApdu->choice.u.roiv_cmipConfirmedEventReport.event_info.value[0]);	
	
	UNUSED(controller_ID)
	*(USB_PACKET_SIZE *)size = PHD_OXI_DIM_DATA_TX_SIZE;
	/* copy the measurements to send in the phd_buffer */
	(void)memcpy(send_buff, PHD_OXI_DIM_DATA_TX, PHD_OXI_DIM_DATA_TX_SIZE);
        
         //Update Timestamp Value increasing Minutes in 1 each time a value is transfered
         au8TimestampArray[1]++;
         if(au8TimestampArray[1] >=60)
         {
          au8TimestampArray[1] -= 60;
          au8TimestampArray[0]++;  
          if(au8TimestampArray[0] >=24)
            au8TimestampArray[0] = 0;
         }

        
        //Increases the report count
        if(PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SCANREPORT_NO_POSITION+1] == 0xFF)
         PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SCANREPORT_NO_POSITION]++;

        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SCANREPORT_NO_POSITION+1]++; 
        
        // Updates the SpO2 Value 
        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SPO2_MEAS_POSITION] = SpO2_SaturationValue;

        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SPO2_MIN_POSITION] = au8TimestampArray[1];//Updates Minutes
        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_SPO2_MIN_POSITION-1] = au8TimestampArray[0];//Updates Hours
        
        // Updates the Pulse Rate Value
        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_PRV_MEAS_POSITION] = SpO2_HeartRate;

        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_PRV_MIN_POSITION] = au8TimestampArray[1];//Updates Minutes
        PHD_OXI_DIM_DATA_TX[OXI_FIXEDREPORT_PRV_MIN_POSITION-1] = au8TimestampArray[0];//Updates Hours
        
        
        
        
}



